<?php $__env->startSection('seo_title', $global_setting->home_seo_title); ?>
<?php $__env->startSection('seo_meta_description', $global_setting->home_seo_meta_description); ?>

<?php $__env->startSection('content'); ?>

<!-- Slider Section -->
<section class="banner-section">
    <div class="banner-carousel owl-carousel owl-theme default-navs">
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="slide-item">
            <div class="bg-image" style="background-image: url(<?php echo e(asset('uploads/'.$item->photo)); ?>);"></div>
            <div class="auto-container">
                <div class="content-box">
                    <?php if($item->text!=''): ?>
                    <h2 class="title animate-1">
                        <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($item->text))); ?>

                    </h2>
                    <?php endif; ?>
                    <?php if($item->button_text!=''): ?>
                    <div class="btn-box animate-2">
                        <a href="<?php echo e($item->button_url); ?>" class="theme-btn btn-style-one hover-light"><span class="btn-title"><?php echo e($item->button_text); ?></span></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>
<!-- End Slider Section -->


<?php if($home_1_page_items->service_on_slider_status == 'Show'): ?>
<section class="services-section-home3 pt-0 pb-90">
    <div class="auto-container">
        <div class="outer-box">
            <div class="row row-cols-sm-2 row-cols-md-3 row-cols-xl-5 justify-content-center">
                <?php $__currentLoopData = $services->take($home_1_page_items->service_on_slider_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="service-block-new-3 at-home6 col wow fadeInUp">
                    <div class="inner-box ">
                        <i class="icon <?php echo e($service->icon); ?>"></i>
                        <h6 class="title"><a href="<?php echo e(route('service',$service->slug)); ?>"><?php echo e($service->name); ?></a></h6>
                        <div class="text"><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($service->short_description))); ?></div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->welcome_status == 'Show'): ?>
<section class="about-section pt-0">
    <div class="auto-container">
        <div class="row">
            <div class="content-column col-lg-6 col-md-12 col-sm-12 order-2 wow fadeInRight">
                <div class="inner-column">
                    <div class="sec-title">
                        <span class="sub-title"><?php echo e($welcome_one_items->subheading); ?></span>
                        <h2><?php echo e($welcome_one_items->heading); ?></h2>
                        <div class="text">
                            <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($welcome_one_items->text))); ?>

                        </div>
                    </div>
                    <?php $__currentLoopData = $welcome_one_item_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="info-box">
                        <div class="inner">
                            <i class="icon <?php echo e($item->icon); ?>"></i>
                            <h5 class="title"><?php echo e($item->heading); ?></h5>
                            <div class="text">
                                <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($item->text))); ?>

                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($welcome_one_items->button_url); ?>" class="theme-btn btn-style-one"><span class="btn-title"><?php echo e($welcome_one_items->button_text); ?></span></a>
                </div>
            </div>
            <div class="image-column col-lg-6 col-md-12 col-sm-12 wow fadeInLeft">
                <div class="image-box">
                    <span class="icon-dots bounce-y"></span>
                    <span class="icon-circle zoom-one"></span>
                    <figure class="image-1 wow fadeIn"><img src="<?php echo e(asset('uploads/'.$welcome_one_items->photo1)); ?>" alt=""></figure>
                    <figure class="image-2 wow fadeIn" data-wow-delay="600ms"><img src="<?php echo e(asset('uploads/'.$welcome_one_items->photo2)); ?>" alt=""></figure>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->service_status == 'Show'): ?>
<section class="services-section">
    <div class="auto-container">
        <div class="sec-title text-center">
            <span class="sub-title"><?php echo e($home_1_page_items->service_subheading); ?></span>
            <h2><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->service_heading))); ?></h2>
        </div>
        <div class="row">
            <?php $__currentLoopData = $services->take($home_1_page_items->service_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="service-block-new-1 col-lg-4 col-md-6 col-sm-12 wow fadeInUp">
                <div class="inner-box">
                    <div class="image-box">
                        <figure class="image"><a href="<?php echo e(route('service',$service->slug)); ?>"><img src="<?php echo e(asset('uploads/'.$service->photo)); ?>" alt="<?php echo e($service->name); ?>"></a></figure>
                        <div class="icon-box"><i class="icon <?php echo e($service->icon); ?>"></i></div>
                    </div>
                    <div class="content-box">
                        <h5 class="title"><a href="<?php echo e(route('service',$service->slug)); ?>"><?php echo e($service->name); ?></a></h5>
                        <div class="text">
                            <?php echo clean(nl2br($service->short_description)); ?>

                        </div>
                        <a href="<?php echo e(route('service',$service->slug)); ?>" class="read-more"><?php echo e(__('Read More')); ?> <i class="<?php if(session('sess_lang_direction') == 'Right to Left (RTL)'): ?> fa fa-long-arrow-alt-left <?php else: ?> fa fa-long-arrow-alt-right <?php endif; ?>"></i></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->video_one_status == 'Show'): ?>
<section class="video-section-new-3">
    <div class="auto-container">
        <div class="video-box-new-3">
            <div class="bg">
                <div class="bg bg-image" style="background-image: url(<?php echo e(asset('uploads/'.$video_one_items->photo)); ?>)"></div>
                <div class="overlay"></div>
            </div>
            <div class="content">
                <div class="btn-box">
                    <a href="https://www.youtube.com/watch?v=<?php echo e($video_one_items->youtube_video_id); ?>" class="play-now" data-fancybox="gallery" data-caption=""><i class="icon fa fa-play" aria-hidden="true"></i><span class="ripple"></span></a>
                </div>
                <h2 class="title"><?php echo e($video_one_items->heading); ?></h2>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->fun_fact_status == 'Show'): ?>
<section class="fun-fact-section-new-3">
    <div class="auto-container">
        <div class="outer-box">
            <div class="row">
                <div class="title-column col-lg-6">
                    <div class="inner-column">
                        <div class="sec-title light">
                            <span class="sub-title"><?php echo e($fun_facts->subheading); ?></span>
                            <h2><?php echo e($fun_facts->heading); ?></h2>
                            <div class="text">
                                <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($fun_facts->text))); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="column col-lg-6">
                    <div class="fact-counter">
                        <div class="row">
                            <?php $__currentLoopData = $fun_fact_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="counter-block-new-3 col-lg-4 col-md-4 col-sm-6 wow fadeInUp">
                                <div class="inner">
                                    <div class="content">
                                        <i class="icon <?php echo e($item->icon); ?>"></i>
                                        <div class="count-box"><span class="count-text" data-speed="3000" data-stop="<?php echo e($item->number); ?>">0</span></div>
                                        <h6 class="counter-title"><?php echo e($item->name); ?></h6>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->portfolio_status == 'Show'): ?>
<section class="projects-section-home3">
    <div class="upper-box">
        <div class="auto-container">
            <div class="sec-title">
                <span class="sub-title"><?php echo e($home_1_page_items->portfolio_subheading); ?></span>
                <h2><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->portfolio_heading))); ?></h2>
            </div>
        </div>
    </div>
    <div class="carousel-outer">
        <div class="projects-carousel owl-carousel owl-theme default-navs">
            <?php $__currentLoopData = $portfolios->take($home_1_page_items->portfolio_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $portfolio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="project-block-home3">
                <div class="image-box">
                    <figure class="image"><a href="<?php echo e(asset('uploads/'.$portfolio->photo)); ?>" class="lightbox-image"><img src="<?php echo e(asset('uploads/'.$portfolio->photo)); ?>" alt=""></a> </figure>
                    <div class="caption-box">
                        <h4 class="title"><a href="<?php echo e(route('portfolio',$portfolio->slug)); ?>"><?php echo e($portfolio->name); ?></a></h4>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->contact_status == 'Show'): ?>
<section class="contact-section pt-120">
    <div class="anim-icons">
        <span class="icon icon-line3"></span>
        <span class="icon icon-arrow1"></span>
        <span class="icon icon-arrow2"></span>
    </div>
    <div class="auto-container">
        <div class="outer-box">
            <div class="bg bg-pattern-5"></div>

            <div class="sec-title">
                <span class="sub-title"><?php echo e($home_1_page_items->contact_subheading); ?></span>
                <h2><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->contact_heading))); ?></h2>
            </div>

            <div class="contact-form wow fadeInLeft">
                <form method="post" action="<?php echo e(route('contact_send_message')); ?>" id="contact-form">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="form-group col-lg-6 col-md-12 col-sm-12">
                            <input type="text" name="name" placeholder="<?php echo e(__('Full Name')); ?>" required>
                        </div>
                        <div class="form-group col-lg-6 col-md-12 col-sm-12">
                            <input type="email" name="email" placeholder="<?php echo e(__('Email Address')); ?>" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <input type="text" name="subject" placeholder="<?php echo e(__('Subject')); ?>" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <textarea name="message" placeholder="<?php echo e(__('Message')); ?>" required></textarea>
                        </div>
                        <?php if($global_setting->google_recaptcha_status == 'Show'): ?>
                        <div class="form-group col-lg-12">
                            <div class="g-recaptcha" data-sitekey="<?php echo e($global_setting->google_recaptcha_site_key); ?>"></div>
                        </div>
                        <?php endif; ?>
                        <div class="form-group col-lg-12">
                            <button class="theme-btn btn-style-one" type="submit" name="submit-form"><span class="btn-title"><?php echo e(__('Send Message')); ?></span></button>
                        </div>
                    </div>
                </form>
            </div>
            <figure class="image"><img src="<?php echo e(asset('uploads/'.$home_contact_photos->home_1_contact_photo)); ?>" alt=""></figure>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->blog_status == 'Show'): ?>
<section class="news-section">
    <div class="auto-container">
        <div class="sec-title text-center">
            <span class="sub-title"><?php echo e($home_1_page_items->blog_subheading); ?></span>
            <h2><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->blog_heading))); ?></h2>
        </div>
        <div class="row">
            <?php $__currentLoopData = $posts->take($home_1_page_items->blog_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="news-block col-lg-4 col-md-6 col-sm-12 wow fadeInUp">
                <div class="inner-box">
                    <div class="image-box">
                        <figure class="image"><a href="<?php echo e(route('post',$post->slug)); ?>"><img src="<?php echo e(asset('uploads/'.$post->photo)); ?>" alt=""></a></figure>
                    </div>
                    <div class="content-box">
                        <span class="date"><?php echo e($post->created_at->format('d M, Y')); ?></span>
                        <ul class="post-info">
                            <li><i class="fa fa-user-circle"></i> <?php echo e(__('by Admin')); ?></li>
                        </ul>
                        <h4 class="title"><a href="<?php echo e(route('post',$post->slug)); ?>"><?php echo e($post->title); ?></a></h4>
                        <a href="<?php echo e(route('post',$post->slug)); ?>" class="read-more"><?php echo e(__('Read More')); ?> <i class="<?php if(session('sess_lang_direction') == 'Right to Left (RTL)'): ?> fa fa fa-long-arrow-alt-left <?php else: ?> fa fa-long-arrow-alt-right <?php endif; ?>"></i></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->video_two_status == 'Show'): ?>
<section class="video-section pull-down">
    <div class="bg bg-pattern-4"></div>
    <div class="auto-container">
        <div class="sec-title text-center light">
            <a href="https://www.youtube.com/watch?v=<?php echo e($video_two_items->youtube_video_id); ?>" class="play-btn" data-fancybox="gallery" data-caption=""><i class="icon fa fa-play" aria-hidden="true"></i></a>
            <h2>
                <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($video_two_items->heading))); ?>

            </h2>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->feature_status == 'Show'): ?>
<section class="features-section-two pt-0">
    <div class="auto-container">
        <div class="outer-box">
            <div class="row">
                <div class="title-column col-lg-3">
                    <div class="inner-column">
                        <h4 class="title">
                            <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($feature_one_items->text))); ?>

                        </h4>
                        <figure class="image"><img src="<?php echo e(asset('uploads/'.$feature_one_items->photo)); ?>" alt=""></figure>
                    </div>
                </div>
                <?php $__currentLoopData = $feature_one_item_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="feature-block-two col-lg-3 col-md-4 col-sm-6">
                    <div class="inner-box">
                        <i class="icon <?php echo e($item->icon); ?>"></i>
                        <h5 class="title"><?php echo e($item->heading); ?></h5>
                        <div class="text">
                            <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($item->text))); ?>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->testimonial_status == 'Show'): ?>
<section class="testimonial-section-home5-v2">
    <div class="bg bg-pattern-7"></div>
    <div class="auto-container">
        <div class="row">
            <div class="title-column col-xl-3 col-lg-12">
                <div class="sec-title">
                    <span class="sub-title"><?php echo e($home_1_page_items->testimonial_subheading); ?></span>
                    <h2><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->testimonial_heading))); ?></h2>
                    <div class="text">
                        <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($home_1_page_items->testimonial_text))); ?>

                    </div>
                </div>
            </div>
            <div class="testimonial-column col-xl-9 col-lg-12">
                <div class="inner-column">
                    <div class="testimonial-carousel owl-carousel owl-theme">
                        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="testimonial-block-home5-v2">
                            <div class="inner-box">
                                <div class="content-box">
                                    <div class="thumb"><img src="<?php echo e(asset('uploads/'.$testimonial->photo)); ?>" alt=""></div>
                                    <div class="rating">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $testimonial->rating): ?>
                                                <i class="fas fa-star"></i>
                                            <?php else: ?>
                                                <i class="far fa-star"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                    <div class="text">
                                        <?php echo clean(nl2br($testimonial->comment)); ?>

                                    </div>
                                </div>
                                <div class="info-box">
                                    <h6 class="name"><?php echo e($testimonial->name); ?></h6>
                                    <span class="designation"><?php echo e($testimonial->designation); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php if($home_1_page_items->why_choose_status == 'Show'): ?>
<section class="why-choose-us-home5 py-0">
    <div class="auto-container">
        <div class="outer-box">
            <div class="row align-items-center">
                <div class="content-column mb-0 col-xl-6 col-lg-7 order-2 wow fadeInRight" data-wow-delay="600ms">
                    <div class="inner-column mb-5 mb-xl-0">
                        <div class="sec-title">
                            <span class="sub-title"><?php echo e($why_choose_one_items->subheading); ?></span>
                            <h2><?php echo e($why_choose_one_items->heading); ?></h2>
                            <div class="text">
                                <?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($why_choose_one_items->text))); ?>

                            </div>
                        </div>
                        <div class="row">
                            <?php $__currentLoopData = $why_choose_one_item_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <div class="feature-box">
                                    <i class="icon <?php echo e($item->icon); ?>"></i>
                                    <h6 class="title"><?php echo str_replace(["<p>", "</p>"], ["", ""], clean(nl2br($item->heading))); ?></h6>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="image-column mb-0 col-xl-6 col-lg-5">
                    <div class="inner-column wow fadeInLeft">
                        <div class="image-box">
                            <figure class="image overlay-anim wow fadeInUp"><img src="<?php echo e(asset('uploads/'.$why_choose_one_items->photo)); ?>" alt=""></figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<?php if($home_1_page_items->client_status == 'Show'): ?>
<section class="clients-section">
    <div class="auto-container">
        <div class="sponsors-outer">
            <ul class="clients-carousel owl-carousel owl-theme">
                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="client-block">
                    <?php if($item->url!=''): ?>
                    <a href="<?php echo e($item->url); ?>">
                        <img src="<?php echo e(asset('uploads/'.$item->photo)); ?>" alt="">
                    </a>
                    <?php else: ?>
                    <a href="javascript:void;">
                        <img src="<?php echo e(asset('uploads/'.$item->photo)); ?>" alt="">
                    </a>
                    <?php endif; ?>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
</section>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\monyancha\Desktop\cms\resources\views/front/home-1.blade.php ENDPATH**/ ?>