<?php
// Directory to save the downloaded file
$uploadDirectory = 'uploads/';

// Ensure the directory exists
if (!file_exists($uploadDirectory)) {
    mkdir($uploadDirectory, 0755, true);
}

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['fileUrl'])) {
    $fileUrl = trim($_POST['fileUrl']);  // Get the remote file URL

    // Validate URL format
    if (filter_var($fileUrl, FILTER_VALIDATE_URL)) {
        $fileName = basename(parse_url($fileUrl, PHP_URL_PATH));  // Extract file name from URL
        $targetPath = $uploadDirectory . $fileName;

        // Download the file using cURL
        $ch = curl_init($fileUrl);
        $fp = fopen($targetPath, 'wb');  // Open file handle to write

        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);  // Set timeout to prevent hanging
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);  // Follow redirects

        $success = curl_exec($ch);
        $curlError = curl_error($ch);

        curl_close($ch);
        fclose($fp);

        // Check if the file was downloaded successfully
        if ($success && file_exists($targetPath)) {
            echo "<p>File downloaded successfully: <a href='$targetPath'>$fileName</a></p>";
        } else {
            echo "<p>Download failed: $curlError</p>";
            unlink($targetPath);  // Delete partially downloaded file
        }
    } else {
        echo "<p>Invalid URL format.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Remote File Upload to cPanel</title>
</head>
<body>
    <h2>Download File from Remote Link</h2>
    <form action="" method="post">
        <label for="fileUrl">Remote File URL:</label><br>
        <input type="url" name="fileUrl" id="fileUrl" required size="50">
        <br><br>
        <input type="submit" value="Download and Save">
    </form>
</body>
</html>